 ; Ŀ
 ;   DC - Dcl file editor.                                                 
 ;   Copyright 1996, 2002 by Rocket Software Ltd.                          
 ;   For Rocket internal use only - do not release.                        
 ; 

 ; Modify: use the filename as the dialog name default but maintain
 ; another global variable in case the dialog is not the main one in the file
 ; and thus doesn't have the same name.

 ; Ŀ
 ;   DT - test load the current dialog box.                                
 ; 
 (DEFUN C:DT (/ dcl_id fn len ddc)
 ; Ŀ
 ;   Ditch the .dcl file extension.                                        
 ;   Save the dialog name to Ddc, leave the global variable alone.         
 ; 
  (setq len (strlen ffdcl))
  (if (= (substr (strcase ffdcl t) (- (strlen ffdcl) 3)) ".dcl")
      (setq ddc (substr ffdcl 1 (- len 4))))
 ; Ŀ
 ;   Remove the path if there is one.                                      
 ; 
  (setq len (strlen ddc))
  (while (and (< 0 len) (/= (substr ddc len 1) (chr 92)))
         (setq len (1- len)))
  (if (> len 0) (setq ddc (substr ddc (1+ len))))
 ; Ŀ
 ;   Load the file, display the dialog.                                    
 ; 
  (setq dcl_id (load_dialog ffdcl))
  (new_dialog ddc dcl_id)
  (start_dialog)
  (unload_dialog dcl_id)
 (princ))
 ; Ŀ
 ;   DT end.                                                               
 ; 

 ; Ŀ
 ;   Dc.                                                                   
 ; 
 (defun C:DC (/ fn tt len ll ch)
  (if (= (type ffdcl) 'str)
      (setq tt (strcat "Dcl file <" ffdcl ">: "))
      (setq tt "Dcl file: "))
  (setq fn (getstring T tt))
  (if (/= fn "") (setq ffdcl fn))
  (setq ll (strlen ffdcl))
  (while (and (< 0 ll) (/= (substr ffdcl ll 1) (chr 92)))
         (if (= (substr ffdcl ll 1) ".")
             (setq ch T))
         (setq ll (1- ll)))
  (if (null ch)
      (setq fn (setq ffdcl (strcat ffdcl ".dcl")))
      (setq fn ffdcl))
  (command "xxx" fn)
 (princ))